// Para5.cpp : implementation file
//

#include "stdafx.h"
#include "3D Printer.h"
//#include "Para5.h"
#include "3D PrinterDlg.h"

#include "typedef.h"
#include "Delay.h"
#include "Command.h"
#include <math.h>
#include "Para5.h"
#include "usbprint.h"

static CPara5* pDlg=NULL;
extern unsigned char CheckDevice(void);
extern unsigned char CheckUSB(void);
extern  volatile BOOL UsbConnect;
//extern HANDLE hDeviceThread;//߳̾
extern double Hour;
extern volatile BOOL bDeviceChange;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPara5 dialog


CPara5::CPara5(CWnd* pParent /*=NULL*/)
	: CDialog(CPara5::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPara5)
	m_StrUpgrateFullName = _T("");
	//}}AFX_DATA_INIT
}


void CPara5::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPara5)
	DDX_Control(pDX, IDC_DEVICE_INDEX, m_DeviceIndex);
	DDX_Control(pDX, IDC_EDIT_UPGRATE_FULLNAME, m_Edit_FullName);
	DDX_Text(pDX, IDC_EDIT_UPGRATE_FULLNAME, m_StrUpgrateFullName);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_LANGUAGE, m_ComboBox1);
}


BEGIN_MESSAGE_MAP(CPara5, CDialog)
	//{{AFX_MSG_MAP(CPara5)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_UPGRATE, OnUpgrate)
	ON_EN_CHANGE(IDC_EDIT_UPGRATE_FULLNAME, OnChangeEditUpgrateFullname)
	ON_BN_CLICKED(IDC_DOWNLOAD_OPEN, OnDownloadOpen)
	ON_BN_CLICKED(IDC_ISP_STOP, OnIspStop)
	ON_BN_CLICKED(IDC_LED_DEFAULT_SET, OnLedDefaultSet)
	ON_BN_CLICKED(IDC_READ_PARA, OnReadPara)
	ON_BN_CLICKED(IDC_LED_TEST, OnLedTest)
	ON_CBN_SELCHANGE(IDC_DEVICE_INDEX, OnSelchangeDeviceIndex)
	ON_BN_CLICKED(IDC_VERSION_GET, OnVersionGet)
	ON_CBN_SELCHANGE(IDC_LANGUAGE,OnCbnSelchangeLanguage)
	ON_BN_CLICKED(IDC_ACT_LANG, OnBnClickedActLang)
	ON_BN_CLICKED(IDC_FANOFF, OnFanoff)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPara5 message handlers

//static double float DoTime;

//DWORD dwBeginTime = ::GetTickCount() // OR timeGetTime();
//DWORD dwEndTime = ::GetTickCount();
//DWORD dwSpaceTime = dwEndTime - dwBeginTime;
CString GetCurrenLanguage(void)
{
	CString Section = "themes";
	CString Key = "Solution";
	CString  inipath;
	CString  Value;
	Value = "";
	GetModuleFileName(NULL, inipath.GetBufferSetLength(MAX_PATH + 1), MAX_PATH);
	inipath.ReleaseBuffer();
	int pos = inipath.ReverseFind('\\');
	inipath = inipath.Left(pos);
	inipath = inipath + "\\Config.ini";
	GetPrivateProfileString((LPCTSTR)Section, (LPCTSTR)Key, (LPCTSTR)Value, Value.GetBuffer(MAX_PATH), MAX_PATH, (LPCTSTR)inipath);
	return Value;
}

void SetCurrenLanguage(CString Language)
{
	CString Section = "themes";
	CString Key = "Solution";
	CString  inipath;
	GetModuleFileName(NULL, inipath.GetBufferSetLength(MAX_PATH + 1), MAX_PATH);
	inipath.ReleaseBuffer();
	int pos = inipath.ReverseFind('\\');
	inipath = inipath.Left(pos);
	inipath = inipath + "\\Config.ini";
	WritePrivateProfileString((LPCTSTR)Section, (LPCTSTR)Key, (LPCTSTR)Language, (LPCTSTR)inipath);
}

extern CString ReadIniString(CString Section,CString Key);
extern void WriteIniString(CString Section,CString Key,CString Value);

static BOOL f_first=TRUE;

BOOL CPara5::OnInitDialog() 
{
	CString StrHour;
	LCID lcid = GetSystemDefaultLCID();
	CString String;
	CDialog::OnInitDialog();
	//U8 flag;
	CString DevIndex;
	//unsigned int i;
	pDlg=this;
	_CWndCS(this);
	// TODO: Add extra initialization here
	f_FanOff=FALSE;
	IsExit=FALSE;
	IsStop=FALSE;
	pThread=NULL;
	if(f_first)
	{
		//ļ򿪰ťͼ
		CButton* pFileOpenButton=(CButton*)GetDlgItem(IDC_DOWNLOAD_OPEN);
		HBITMAP hBmp = LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BITMAP1));
		pFileOpenButton->SetBitmap(hBmp);
		IspWorking=FALSE;
		IspCancel=FALSE;
		LoaderSize=0;
		FirmWareSize=0;
		UpdateData(FALSE);
		m_ComboBox1.SetCurSel(-1);
		m_ComboBox1.AddString(_CS("ConfigGeneral.English"));
		m_ComboBox1.AddString(_CS("ConfigGeneral.SimpChinese"));

		if (GetCurrenLanguage() == "English")
			m_ComboBox1.SetCurSel(0);
		else if (GetCurrenLanguage() == "SimpChinese")
			m_ComboBox1.SetCurSel(1);
		else
		{
			if((lcid&0xff) == 0x09)//English
				m_ComboBox1.SetCurSel(0);
			else if ((lcid & 0xff) == 0x04)//SimpChinese
				m_ComboBox1.SetCurSel(1);
			else
				m_ComboBox1.SetCurSel(0);
		}
		//-----------------------------
		/*
		m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
			DevIndex.Format(" %d ",i);
			m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_DeviceIndex.AddString(" XXX ");
		m_DeviceIndex.SetCurSel(0);
		*/
		//-----------------------------
		UpdateData(TRUE);

		f_first = FALSE;
	}
	
	StrHour.Format("%.1f",Hour);
		::SetDlgItemText(pDlg->GetSafeHwnd(),IDC_USE_HOUR,StrHour);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CPara5::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	if(pThread!=NULL)
	{
		IsExit=TRUE;
	}
	else 
	{
		CDialog::OnClose();
	}
}
//=================================================================================
#define CMD_RUN_BOOT      0xf9
#define CMD_BUFFER_SIZE	  0xfa
#define CMD_WRITE         0xfb
#define CMD_READ          0xfc
#define CMD_RUN_APP       0xfd
#define CMD_MAGIC         0xfe

unsigned int GetBlockSize(void)
{
    unsigned char buffer[10];
    unsigned int Size=0;
    buffer[0]=CMD_BUFFER_SIZE;
    PackageTransmit(buffer,1,1000);
    PackageReceive((unsigned char*)&Size,4,1000);
    return Size;
    //return 512;
}

BOOLEAN ispWrite(unsigned long Address,unsigned long Size,unsigned char *Data)
{
    unsigned char   *buffer;
    unsigned char *RevBuf;
    if(Data==NULL)
        return FALSE;
    buffer =(unsigned char *) malloc (Size+9);
    RevBuf =(unsigned char *) malloc (Size+9);
    if(buffer==NULL || RevBuf==NULL)
    {
        return FALSE;
    }
    //Command
    buffer[0]=CMD_WRITE;
    //Address 4 Bytes low first
    buffer[1]=(unsigned char)((Address>>0)&0xff);
    buffer[2]=(unsigned char)((Address>>8)&0xff);
    buffer[3]=(unsigned char)((Address>>16)&0xff);
    buffer[4]=(unsigned char)((Address>>24)&0xff);
    //Data len 4 Byte low first
    buffer[5]=(unsigned char)((Size>>0)&0xff);
    buffer[6]=(unsigned char)((Size>>8)&0xff);
    buffer[7]=(unsigned char)((Size>>16)&0xff);
    buffer[8]=(unsigned char)((Size>>24)&0xff);
    memcpy(buffer+9,Data,Size);
    memcpy(RevBuf,buffer,9);

    if(PackageTransmit(buffer,Size+9,2000)==0)
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }
    Delay1Ms(15);//60
    //----------------------------------------------------------
    RevBuf[0]=CMD_READ;
    if (PackageTransmit(RevBuf,9,2000)==0)
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }

    if(PackageReceive(RevBuf+9,Size,2000)==0)
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }
    if(memcmp(RevBuf+9,buffer+9,Size))
    {
        free (buffer);
        free (RevBuf);
        return FALSE;
    }
    free (buffer);
    free (RevBuf);
  return TRUE;
}

BOOLEAN ispRead(unsigned long Address,unsigned long Size,unsigned char *Data)
{
    //unsigned char   buffer[10];
    unsigned char   *buffer;
    if(Data==NULL)
        return FALSE;
    buffer =(unsigned char *) malloc (Size+9);
    if(buffer==NULL)
        return FALSE;
    //unsigned long nBytesWritten,nBytesRead;
    //Command
    buffer[0]=CMD_READ;
    //Address 4 Bytes low first
    buffer[1]=(unsigned char)((Address>>0)&0xff);
    buffer[2]=(unsigned char)((Address>>8)&0xff);
    buffer[3]=(unsigned char)((Address>>16)&0xff);
    buffer[4]=(unsigned char)((Address>>24)&0xff);
    //Data len 4 Byte low first
    buffer[5]=(unsigned char)((Size>>0)&0xff);
    buffer[6]=(unsigned char)((Size>>8)&0xff);
    buffer[7]=(unsigned char)((Size>>16)&0xff);
    buffer[8]=(unsigned char)((Size>>24)&0xff);

    if (PackageTransmit(buffer,9,2000)==0)
    {
        free (buffer);
        return FALSE;
    }

    if(PackageReceive(Data,Size,2000)==0)
    {
        free (buffer);
        return FALSE;
    }
    free (buffer);
    Delay1Ms(20);
    return TRUE;
}

BOOLEAN ispRunBoot(void)
{
    unsigned char buffer[10];
    buffer[0]=CMD_RUN_BOOT;
    return PackageTransmit(buffer,1,2000);
}

BOOLEAN ispRunApp(void)
{
    unsigned char buffer[10];
    buffer[0]=CMD_RUN_APP;
    return PackageTransmit(buffer,1,2000);
}

void ispMagic(unsigned char *Magic)
{
    unsigned char buffer[10];
    buffer[0]=CMD_MAGIC;
    PackageTransmit(buffer,1,1000);
    PackageReceive(Magic,3,1000);
    return ;
}
//=================================================================================
DWORD WINAPI UartCheck_Thread(LPVOID pParam);
UINT WINAPI Upgrate_Thread(LPVOID pParam)
{
	
	HWND   hwndUpGrate=GetDlgItem(pDlg->GetSafeHwnd(),IDC_UPGRATE);
	HWND   hwndUart=GetDlgItem(pDlg->GetSafeHwnd(),IDC_UART);
	HWND   hwndDownloadOpen=GetDlgItem(pDlg->GetSafeHwnd(),IDC_DOWNLOAD_OPEN);
	
	HWND   hwndIspStop=GetDlgItem(pDlg->GetSafeHwnd(),IDC_ISP_STOP);
	
    EnableWindow(hwndUpGrate,FALSE);
	EnableWindow(hwndUart,FALSE);
	EnableWindow(hwndDownloadOpen,FALSE);
	EnableWindow(hwndIspStop,TRUE);

	//================================================================================
	unsigned char *BlockBuffer=NULL;
	unsigned char *LoaderBuffer=NULL;
	unsigned char *FirmWareBuffer=NULL;
	unsigned long LoaderSize;
	unsigned long FirmWareSize;
	unsigned char IspSucceed=0;
    int i=0;
    int Percent,PercentOffset=0;
    unsigned long Address=0;
    unsigned long offset=0;
    unsigned long BlockSize=0;
    unsigned long leng;
    unsigned char Magic[3];
	HWND   hwndProgress=GetDlgItem(pDlg->GetSafeHwnd(),IDC_PROGRESS1);
    LoaderSize=pDlg->LoaderSize;
	FirmWareSize=pDlg->FirmWareSize;
	LoaderBuffer=pDlg->LoaderBuffer;
    FirmWareBuffer=pDlg->FirmWareBuffer;
	SendMessage(hwndProgress,PBM_SETRANGE,0,MAKELONG(0,100));
	SendMessage(hwndProgress,PBM_SETSTEP,1,0);
	SendMessage(hwndProgress,PBM_SETPOS,0,0);
    ispMagic(Magic);
    if(Magic[0]=='A' && Magic[1]=='P' && Magic[2]=='P')
    {
        BlockSize=GetBlockSize();
        if(BlockSize==0)
        {
            pDlg->IspCancel=0;
            IspSucceed=0;
			goto ExitLable;
        }
        leng=LoaderSize;
        while(leng)
        {
            if(pDlg->IspCancel)
            {
				goto ExitLable;
            }
            if(leng>BlockSize)
            {
                if(ispWrite(Address+offset,BlockSize,&LoaderBuffer[offset])==FALSE)
                {
                    IspSucceed=0;
					goto ExitLable;
                }
                offset=offset+BlockSize;
                leng=leng-BlockSize;
                Percent=50*(offset/(LoaderSize*1.0));
				SendMessage(hwndProgress,PBM_SETPOS,Percent,0);
            }
            else
            {
                if(ispWrite(Address+offset,leng,&LoaderBuffer[offset])==FALSE)
                {
                    IspSucceed=0;
					goto ExitLable;
                }
                leng=0;
				SendMessage(hwndProgress,PBM_SETPOS,50,0);
            }
        }
		UsbConnect=FALSE;
        ispRunBoot();
        for(i=0;i<16;i++)
        {
		  Delay1Ms(1000);
		  EnumUsbDevice();//ö
		  UsbConnect=CheckUSBOnline();
		  if(UsbConnect==FALSE)
			  continue;
		  else
			  break;
        }
        if(i==16)//time out
        {
            IspSucceed=0;
			goto ExitLable;
        }
        PercentOffset=50;
		Delay1Ms(1000);
    }

    Address=0;
    offset=0;
    BlockSize=0;
    BlockSize=GetBlockSize();
    if(BlockSize==0)
    {
        pDlg->IspCancel=0;
        IspSucceed=0;
		goto ExitLable;
    }

	BlockBuffer=(unsigned char *) malloc (BlockSize);
	if(BlockBuffer==NULL)
	{
		pDlg->IspCancel=0;
        IspSucceed=0;
		goto ExitLable;
	}

    leng=FirmWareSize;
    while(leng)
    {
        if(pDlg->IspCancel)
        {
			goto ExitLable;
        }
        if(leng>BlockSize)
        {
			if((Address+offset)>=(9*1024))
			{
				//if(ispRead(Address+offset,BlockSize,BlockBuffer)==FALSE)
				//{
				//	IspSucceed=0;
				//	goto ExitLable;
				//}
				
				//if(memcmp(BlockBuffer,&FirmWareBuffer[offset],BlockSize))
				{
					if(ispWrite(Address+offset,BlockSize,&FirmWareBuffer[offset])==FALSE)
					{
						IspSucceed=0;
						goto ExitLable;
					}
				}
			}

            offset=offset+BlockSize;
            leng=leng-BlockSize;
            if(PercentOffset)
                Percent=50*(offset/(FirmWareSize*1.0))+PercentOffset;
            else
                Percent=100*(offset/(FirmWareSize*1.0));
			SendMessage(hwndProgress,PBM_SETPOS,Percent,0);
        }
        else
        {
			if((Address+offset)>=(9*1024))
			{
				//if(ispRead(Address+offset,leng,BlockBuffer)==FALSE)
				//{
				//	IspSucceed=0;
				//	goto ExitLable;
				//}
				//if(memcmp(BlockBuffer,&FirmWareBuffer[offset],leng))
				{
					if(ispWrite(Address+offset,leng,&FirmWareBuffer[offset])==FALSE)
					{
						IspSucceed=0;
						goto ExitLable;
					}
				}
			}

            leng=0;
			SendMessage(hwndProgress,PBM_SETPOS,100,0);
        }
    }
    pDlg->IspWorking=FALSE;
    ispRunApp();
    Delay1Ms(3000);
	//UsbConnect=ShakeHands(0,0);
    IspSucceed=1;
ExitLable:
	if(BlockBuffer!=NULL)
		free(BlockBuffer);
	pDlg->IspWorking=FALSE;
    if(pDlg->IspCancel)
	{
		EnableWindow(hwndUpGrate,TRUE);
		EnableWindow(hwndUart,TRUE);
		EnableWindow(hwndDownloadOpen,TRUE);
		EnableWindow(hwndIspStop,FALSE);
		pDlg->pThread=NULL;
		pDlg->IspCancel=0;
		SendMessage(hwndProgress,PBM_SETPOS,0,0);
		//ResumeThread(hDeviceThread);
		//hDeviceThread=CreateThread(NULL,0,UartCheck_Thread,NULL,0,NULL);
		return 1;
	}
	if(IspSucceed)
		pDlg->MessageBox(_CS("WarningSystem.FirmWareUpgrateSuccess"),_CS("WarningSystem.Title"),MB_OK);
	else
		pDlg->MessageBox(_CS("WarningSystem.FirmWareUpgrateFail"),_CS("WarningSystem.Title"),MB_OK);
	SendMessage(hwndProgress,PBM_SETPOS,0,0);
	//================================================================================

    EnableWindow(hwndUpGrate,TRUE);
	EnableWindow(hwndUart,TRUE);
	EnableWindow(hwndDownloadOpen,TRUE);
	EnableWindow(hwndIspStop,FALSE);
	pDlg->pThread=NULL;
	
	//hDeviceThread=CreateThread(NULL,0,UartCheck_Thread,NULL,0,NULL);
	return 1;
}

void CPara5::OnUpgrate() 
{
	// TODO: Add your control notification handler code here
	CString FilePath;
	CString path; 
    CFile file;
    UpdateData(TRUE);
    
	if(CheckDevice()==FALSE)//if(CheckUSB()==0)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return;
	}
	if(m_StrUpgrateFullName=="")
	{
		MessageBox(_CS("WarningSystem.InvalidFileName"),_CS("WarningSystem.Title"),MB_OK);
		return;
	}
    
	//--------------------------------------------------------------------

	if(file.Open(_T(m_StrUpgrateFullName),CFile::modeRead)==FALSE)
    {
		MessageBox(_CS("WarningSystem.FirmWareUpgrateFail"),_CS("WarningSystem.Title"),MB_OK);
		file.Close();
		return ;
	}
	file.SeekToBegin();///Ƶļͷ
	FirmWareSize=file.GetLength();
	if(FirmWareSize<=10240 || FirmWareSize>126*1024)
	{
		MessageBox(_CS("WarningSystem.FirmWareUpgrateFail"),_CS("WarningSystem.Title"),MB_OK);
		file.Close();
		return;
	}

	file.Read(FirmWareBuffer,FirmWareSize);
	file.Close();
	
    GetModuleFileName(NULL,path.GetBufferSetLength(MAX_PATH+1),MAX_PATH);
    path.ReleaseBuffer(); 
    int pos = path.ReverseFind('\\'); 
    path = path.Left(pos);
	FilePath=path + "\\usbloader.bin";
	if(file.Open(FilePath,CFile::modeRead)==FALSE)
	{
		FilePath=path + "\\usbloader.enc";
		if(file.Open(FilePath,CFile::modeRead)==FALSE)
		{
			MessageBox(_CS("WarningSystem.FirmWareUpgrateFail"),_CS("WarningSystem.Title"),MB_OK);
			return ;
		}
	}
	LoaderSize=file.GetLength();
	if(LoaderSize==0 || LoaderSize>10240)
	{
		MessageBox(_CS("WarningSystem.FirmWareUpgrateFail"),_CS("WarningSystem.Title"),MB_OK);
		file.Close();
		return ;
	}
	
	file.Read(LoaderBuffer,LoaderSize);
	file.Close();
	//--------------------------------------------------------------------
	IspWorking=TRUE;
	/*
	Sleep(300);
	UsbConnect=ShakeHands(0,0);
	if(UsbConnect==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return;
	}
	*/
	pThread=AfxBeginThread((AFX_THREADPROC)Upgrate_Thread,NULL);
}

void CPara5::OnChangeEditUpgrateFullname() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	//UpdateData(FALSE);
}

void CPara5::OnDownloadOpen() 
{
	// TODO: Add your control notification handler code here
	CFileDialog dlg(TRUE,_T(""),_T(""),OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,_T("encļ(*.enc)|*.enc|ļ(*.bin)|*.bin|ļ(*.*)|*.*||"));//"ļ(*.*)|*.*|"
	if(IDOK==dlg.DoModal())
	{
		m_StrUpgrateFullName=dlg.GetPathName();
		UpdateData(FALSE);
		//(CButton*)GetDlgItem(IDC_DOWN_LOAD)->EnableWindow(TRUE);
	}
}

void CPara5::OnIspStop() 
{
	// TODO: Add your control notification handler code here
	HWND   hwndIspStop=::GetDlgItem(pDlg->GetSafeHwnd(),IDC_ISP_STOP);
	::EnableWindow(hwndIspStop,FALSE);
	IspCancel=TRUE;
}

BOOL CPara5::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_ESCAPE) 
		return TRUE; 
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN) 
		return TRUE;
	return CDialog::PreTranslateMessage(pMsg);
}
void CPara5::OnCbnSelchangeLanguage()
{
	// TODO:  ڴӿؼ֪ͨ
	unsigned char Index;
	Index = m_ComboBox1.GetCurSel();
	if (Index == 0)
		SetCurrenLanguage("English");
	else if (Index == 1)
		SetCurrenLanguage("SimpChinese");
}


void CPara5::OnBnClickedActLang()
{
	// TODO:  ڴӿؼ֪ͨ
	BOOL bNormal = TRUE;
	PROCESS_INFORMATION   info;
	STARTUPINFO startup;
	char szPath[512];
	char *szCmdLine;
	GetModuleFileName(AfxGetApp()->m_hInstance, szPath, sizeof(szPath));
	szCmdLine = GetCommandLine();
	GetStartupInfo(&startup);
	BOOL   bSucc = CreateProcess(szPath, szCmdLine, NULL, NULL,
		FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &startup, &info);
	if (bNormal   &&   bSucc)
	{
		CWnd *pWnd = AfxGetMainWnd();
		if (pWnd != NULL)
		{
			pWnd->PostMessage(WM_CLOSE, 0, 0);
		}
		else
			ExitProcess(-1);
	}
	else
		ExitProcess(-1);
}

void CPara5::OnLedDefaultSet() 
{
	// TODO: Add your control notification handler code here
	int   iRadioButton;   
	iRadioButton=GetCheckedRadioButton(IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF); 
	BOOLEAN flag;
	if(iRadioButton==IDC_LED_DEFAULT_OFF)
		flag=1;
	else
		flag=0;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	
	if(SetLedDefaultStatus(flag)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
	}
}

UINT WINAPI ReadPara_Thread(LPVOID pParam)
{
	HWND   hwndReadPara=GetDlgItem(pDlg->GetSafeHwnd(),IDC_READ_PARA);

	short int Temperature;
	CString str_Temperature;
    EnableWindow(hwndReadPara,FALSE);
	if(GetTemperature(&Temperature)==FALSE)
	{
		str_Temperature="----";
		::SetDlgItemText(pDlg->GetSafeHwnd(),IDC_STATIC_TEMP,str_Temperature);
		pDlg->MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		EnableWindow(hwndReadPara,TRUE);
		return 1;
	}
	
	if(Temperature==-100)
		str_Temperature="----";
	else
		str_Temperature.Format("%d",Temperature);
	
	::SetDlgItemText(pDlg->GetSafeHwnd(),IDC_STATIC_TEMP,str_Temperature);
	//--------------------------------------------------
	U32 UseTime;
	CString StrHour;
	
	if(GetUseTime(&UseTime)==FALSE)
	{
		//UartError=TRUE;
		pDlg->MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		EnableWindow(hwndReadPara,TRUE);
		return 1;
	}
	
	Hour=UseTime/(3600.0f);
	StrHour.Format("%.1f",Hour);
	::SetDlgItemText(pDlg->GetSafeHwnd(),IDC_USE_HOUR,StrHour);
	//----------------------------------------------------
	U8 Value=0;
	CString StrLedDefaultStatus;
	if(GetLedDefaultStatus(&Value))
	{
		if(Value)
			StrLedDefaultStatus=_CS("Led.Off");
		else
			StrLedDefaultStatus=_CS("Led.On");
		::SetDlgItemText(pDlg->GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
	}
	else
		pDlg->MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
	EnableWindow(hwndReadPara,TRUE);
	return 1;
}

void CPara5::OnReadPara() 
{
	// TODO: Add your control notification handler code here
	if(CheckDevice()==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}

    //-----------------------------------------------------
	AfxBeginThread((AFX_THREADPROC)ReadPara_Thread,NULL);
}

void CPara5::OnLedTest() 
{
	// TODO: Add your control notification handler code here
	U8 flag;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(GetSysStatus()!=MODE_NORMAL)
	{
		MessageBox(_CS("Led.TestWarning"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(LedTest(&flag)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	//if(flag)
	//	MessageBox(_CS("Led.TestOk"),_CS("WarningUart.Title"),MB_OK);
    //else
	//  MessageBox(_CS("Led.TestFail"),_CS("WarningUart.Title"),MB_OK);
}

void CPara5::OnSelchangeDeviceIndex() 
{
	// TODO: Add your control notification handler code here
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	HWND hwndStatusBar=p->m_StatusBar.GetSafeHwnd();
	HWND hwndLedIndex=p->m_para1.m_LedIndex.GetSafeHwnd();
	U32 UseTime;
	CString StrHour;
	CString StrLedDefaultStatus;
	U8 Value=0,Index;
	CString StrVal;
	U16 u16Value=0;
	BOOLEAN bAuto=0;
	//unsigned char flag;
	unsigned char ID[8];
	CString StrTxt;
	if(p->m_para5.IspWorking)
	{
		UpdateData(FALSE);
		return;
	}
	if(bDeviceChange)
		return;
	if(USBDeviceInfo.count==0)
		return;
	UpdateData(TRUE);
	USBDevIndex=m_DeviceIndex.GetCurSel();
	if(CheckUSBOnline()==FALSE)
	{
		StrTxt=" " + _CS("WarningGeneral.DeviceDisconnect");
		::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		StrTxt="SN: XX-XX-XX-XX-XX-XX";
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		UsbConnect=FALSE;
		return;
	}
	StrTxt=" " + _CS("WarningGeneral.DeviceConnect");
	::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
	UsbConnect=TRUE;
	//if(strcmp(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0])==0)
	//	return;
	memset(DeviceName,0,MAX_PATH);
	strcpy(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0]);
	if(CheckDevice()==1)
	{
		if(GetLedDefaultStatus(&Value))
		{
			if(Value)
				StrLedDefaultStatus=_CS("Led.Off");
			else
				StrLedDefaultStatus=_CS("Led.On");
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
		}
		GetProductID(ID);
		StrTxt.Format("SN: %02X-%02X-%02X-%02X-%02X-%02X",ID[0],ID[1],ID[2],ID[3],ID[4],ID[5]);
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		//----------------------------------
		Index=(int)::SendMessage(hwndLedIndex, CB_GETCURSEL, 0, 0);
		//Index=m_para1.m_LedIndex.GetCurSel();
		if(GetCurrent(Index,&Value)==FALSE)
			return;	
		if(Value>100)
			return;
		StrVal.Format("%d",Value);
		p->m_para1.m_Slider_Led.SetPos(Value);
		p->m_para1.SliderPos=Value;
		::SetDlgItemText(p->m_para1.GetSafeHwnd(),IDC_EDIT_LED,StrVal);
		if(GetUseTime(&UseTime))
		{
			Hour=UseTime/(3600.0f);
			StrHour.Format("%.1f",Hour);
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_USE_HOUR,StrHour);
		}		
	}
}



void CPara5::OnVersionGet() 
{
	// TODO: Add your control notification handler code here
	CString StrVal;
	U16 Version;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	if(GetMyVersion(&Version)==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}

	StrVal.Format("%d.%02d",Version/100,Version%100);
	SetDlgItemText(IDC_VERSION_VALUE,StrVal);
}

void CPara5::OnFanoff() 
{
	// TODO: Add your control notification handler code here
	//int i=0;
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return ;
	}
	UpdateData(TRUE);
	if(f_FanOff)
	{
		
		if(FanOnOff(1)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return ;
		}
		
		f_FanOff=FALSE;
		SetDlgItemText(IDC_FANOFF,_CS("FanOff"));
	}
	else
	{

		if(FanOnOff(0)==FALSE)
		{
			MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
			return;
		}
		
		f_FanOff=TRUE;
		SetDlgItemText(IDC_FANOFF,_CS("FanOn"));
	}
	
}
